package com.agilex.healthcare.veteranappointment.resources;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.mdws.client.v1.mobilehealthplatform.domain.MhpUser;
import gov.va.vamf.security.v1.VamfUser;

import javax.ws.rs.container.ContainerRequestContext;

public abstract class AbstractUserResource {

	protected MhpUser getCurrentUser(ContainerRequestContext context) {
		VamfUser user = getCurrentVamfUser(context);
		return (user != null) ? user.getMhpUser() : null;
	}
	
	protected String getCurrentUserId(ContainerRequestContext context) {
		MhpUser user = getCurrentUser(context);
		return (user != null) ? user.getId() : null;
	}

	protected VamfUser getCurrentVamfUser(ContainerRequestContext context) {
		return (VamfUser)context.getSecurityContext().getUserPrincipal();
	}
}
